/*
 * Decompiled with CFR 0.152.
 */
package filenet.sim.animationdp.test;

import filenet.sim.animationdp.IVWSIMAnimationDP;
import filenet.sim.animationdp.IVWSIMEvent;
import filenet.sim.animationdp.impl2.VWSIMAnimationDP;
import filenet.sim.api.VWScenarioDefinition;
import filenet.sim.api.VWScenarioValidationError;
import filenet.vw.api.VWSession;
import filenet.vw.idm.toolkit.IVWIDMDialog;
import filenet.vw.idm.toolkit.IVWIDMDocument;
import filenet.vw.idm.toolkit.IVWIDMFactory;
import filenet.vw.idm.toolkit.VWIDMBaseFactory;
import filenet.vw.toolkit.utils.IVWParameterConstants;
import filenet.vw.toolkit.utils.VWCommandLineArgs;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.rmi.Naming;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import simulator.ISimulator;
import simulator.scenario.BasicScenario;

public class TestAll
extends Panel
implements IVWParameterConstants {
    protected Button buttonConnect;
    protected Button buttonPickScenario;
    protected Button buttonStartSimulation;
    protected Button buttonStartAnimation;
    protected Button buttonPickEventBuffer;
    protected Button buttonLoadAnimationDPLocally;
    protected Button buttonGenerateXML;
    protected Button buttonGetSimulations;
    protected Button buttonLoadAnimationDPViaSimDoc;
    public TextField portTextField;
    public TextField serverTextField;
    public TextField scenarioFileNameTextField;
    public TextField scenarioNameTextField;
    public TextField scenarioGUIDTextField;
    public TextField eventBufferFileNameTextField;
    public TextField PERouterTextField = new TextField("rmi://localhost:32771/vwrouter");
    public TextField PEUserTextField = new TextField("Administrator");
    public TextField PEPWTextField = new TextField("trident");
    public FileDialog m_openFileDialog;
    public FileDialog m_saveFileDialog;
    private static final Dimension vstrut3 = new Dimension(1, 3);
    private Frame m_pFrame;
    ISimulator m_simEngine = null;
    String m_url = null;
    String m_scenarioGUID = null;
    String m_scenarioFileName = null;
    String m_eventBufferFileName = null;
    protected static IVWIDMFactory m_factory = null;
    protected static IVWIDMDialog openDocDialog = null;

    public TestAll(Frame frame) {
        this.m_pFrame = frame;
        this.m_openFileDialog = new FileDialog(this.m_pFrame, "Open Scenario file..", 0);
        this.m_saveFileDialog = new FileDialog(this.m_pFrame, "Save Scenario file..", 1);
        try {
            System.out.println("TestAll <init>");
            this.setLayout(new BoxLayout(this, 1));
            this.add(Box.createRigidArea(vstrut3));
            this.add(new Label("SIM Server:"));
            this.serverTextField = new TextField(128);
            this.serverTextField.setText("localhost");
            this.add(this.serverTextField);
            this.add(Box.createRigidArea(vstrut3));
            this.add(new Label("Port:"));
            this.portTextField = new TextField(80);
            this.portTextField.setText("32771");
            this.add(this.portTextField);
            this.add(new Label("Scenario XML File Name:"));
            this.scenarioFileNameTextField = new TextField(80);
            this.add(this.scenarioFileNameTextField);
            this.add(new Label("Scenario Name:"));
            this.scenarioNameTextField = new TextField(80);
            this.add(this.scenarioNameTextField);
            this.add(new Label("Scenario GUID:"));
            this.scenarioGUIDTextField = new TextField(80);
            this.add(this.scenarioGUIDTextField);
            this.add(new Label("Event Buffer FileName:"));
            this.eventBufferFileNameTextField = new TextField(80);
            this.add(this.eventBufferFileNameTextField);
            this.add(new Label("PE Router: "));
            this.add(this.PERouterTextField);
            this.add(new Label("PE User: "));
            this.add(this.PEUserTextField);
            this.add(new Label("PE Password: "));
            this.add(this.PEPWTextField);
            this.add(Box.createRigidArea(vstrut3));
            this.add(this.buttonPanel());
            this.updateLookAndFeel();
        }
        catch (Exception ex) {
            System.out.println("Get exception: " + ex.getMessage());
            ex.printStackTrace();
            JOptionPane.showMessageDialog(this.m_pFrame, ex.getMessage(), "EXCEPTION", 0);
        }
    }

    public Panel buttonPanel() {
        Panel p = new Panel(new GridLayout(5, 3));
        this.buttonConnect = new Button("Connect..");
        this.buttonConnect.addActionListener(new ConnectToSimEngineAction(this.m_pFrame));
        p.add(this.buttonConnect);
        this.buttonPickScenario = new Button("Pick scenario file to start...");
        this.buttonPickScenario.addActionListener(new PickScenarioAction(this.m_pFrame));
        this.buttonPickScenario.setEnabled(true);
        p.add(this.buttonPickScenario);
        this.buttonPickEventBuffer = new Button("Pick event buffer file ...");
        this.buttonPickEventBuffer.addActionListener(new PickEventBufferAction(this.m_pFrame));
        this.buttonPickEventBuffer.setEnabled(true);
        p.add(this.buttonPickEventBuffer);
        this.buttonStartSimulation = new Button("Start Simulation...");
        this.buttonStartSimulation.setEnabled(false);
        this.buttonStartSimulation.addActionListener(new StartSimulationAction(this.m_pFrame));
        p.add(this.buttonStartSimulation);
        this.buttonStartAnimation = new Button("Show Animation DP via RMI to Sim Engine..");
        this.buttonStartAnimation.setEnabled(false);
        this.buttonStartAnimation.addActionListener(new ShowAnimationAction(this.m_pFrame));
        p.add(this.buttonStartAnimation);
        this.buttonLoadAnimationDPLocally = new Button("Load Animation DP locally..");
        this.buttonLoadAnimationDPLocally.setEnabled(true);
        this.buttonLoadAnimationDPLocally.addActionListener(new LoadAnimationDPLocallyAction(this.m_pFrame));
        p.add(this.buttonLoadAnimationDPLocally);
        this.buttonLoadAnimationDPViaSimDoc = new Button("Load Animation DP Via SimDoc..");
        this.buttonLoadAnimationDPViaSimDoc.setEnabled(true);
        this.buttonLoadAnimationDPViaSimDoc.addActionListener(new LoadAnimationDPViaSimDocAction(this.m_pFrame));
        p.add(this.buttonLoadAnimationDPViaSimDoc);
        this.buttonGenerateXML = new Button("Generate Runtime XML for a scenario definition.");
        this.buttonGenerateXML.setEnabled(true);
        this.buttonGenerateXML.addActionListener(new GenerateXMLAction(this.m_pFrame));
        p.add(this.buttonGenerateXML);
        this.buttonGetSimulations = new Button("Get simulations from server");
        this.buttonGetSimulations.setEnabled(false);
        this.buttonGetSimulations.addActionListener(new GetSimulationsAction(this.m_pFrame));
        p.add(this.buttonGetSimulations);
        return p;
    }

    protected void updateLookAndFeel() {
        String lnfName = "com.sun.java.swing.plaf.windows.WindowsLookAndFeel";
        try {
            UIManager.setLookAndFeel(lnfName);
            SwingUtilities.updateComponentTreeUI(this);
        }
        catch (UnsupportedLookAndFeelException ex) {
            System.err.println("UnsupportedLookAndFeel: " + lnfName);
        }
        catch (ClassNotFoundException ex) {
            System.err.println("LookAndFeel class not found: " + lnfName);
        }
        catch (InstantiationException ex) {
            System.err.println("Could not load LookAndFeel: " + lnfName);
        }
        catch (IllegalAccessException ex) {
            System.err.println("Cannot Use LookAndFeel: " + lnfName);
        }
        catch (ClassCastException ex) {
            System.err.println("Cannot Use LookAndFeel: " + lnfName);
        }
    }

    public static void main(String[] args) {
        VWCommandLineArgs c = new VWCommandLineArgs(args, true);
        if (c.isPresent("Help") || c.isPresent("help")) {
            System.exit(1);
        }
        try {
            String inputFile = c.getParameter("inputfile");
            c = inputFile != null ? new VWCommandLineArgs(inputFile, false) : new VWCommandLineArgs(args, false);
            m_factory = VWIDMBaseFactory.instance(c);
            openDocDialog = m_factory.getOpenDialog(null, "OK");
            Frame frame = new Frame();
            frame.setTitle("SIMULATION AND ANIMATION DP TEST");
            frame.setBackground(Color.lightGray);
            frame.setLayout(new BorderLayout());
            frame.add("Center", new TestAll(frame));
            frame.addWindowListener(new AppCloser());
            frame.pack();
            frame.setSize(500, 600);
            frame.show();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected class _windowAdapter
    extends WindowAdapter {
        Dialog dlg;

        public _windowAdapter(Dialog d) {
            this.dlg = d;
        }

        public void windowClosing(WindowEvent evt) {
            this.dlg.setVisible(false);
        }
    }

    protected static final class AppCloser
    extends WindowAdapter {
        protected AppCloser() {
        }

        public void windowClosing(WindowEvent e) {
            System.exit(0);
        }
    }

    protected class AnimationDialog
    extends Dialog {
        private TextArea txtArea;
        private Button buttonGetNext;
        private Button buttonStop;
        private Button buttonSave;
        private Button buttonRestart;
        private IVWSIMAnimationDP m_animationDP;

        public AnimationDialog(Frame m_pFrame, IVWSIMAnimationDP animationDP) throws Exception {
            super(m_pFrame, true);
            this.txtArea = new TextArea("Press GET NEXT EVENT button to start..", 30, 100, 0);
            this.buttonGetNext = new Button("GET NEXT EVENT");
            this.buttonStop = new Button("Stop");
            this.buttonSave = new Button("Save Event Buffer");
            this.buttonRestart = new Button("Restart");
            this.setLayout(new BorderLayout());
            this.add((Component)new Label("Scenario " + TestAll.this.m_scenarioGUID), "North");
            this.txtArea.setEditable(true);
            this.add((Component)this.txtArea, "Center");
            Panel p = new Panel();
            this.buttonGetNext.addActionListener(new GetNextEventAction(this));
            this.buttonStop.addActionListener(new CloseAnimationDialogAction(this));
            this.buttonSave.addActionListener(new SaveEventBufferAction(this));
            this.buttonRestart.addActionListener(new RestartAnimationAction(this));
            p.add(this.buttonGetNext);
            p.add(this.buttonStop);
            p.add(this.buttonSave);
            p.add(this.buttonRestart);
            this.add((Component)p, "South");
            this.pack();
            this.addWindowListener(new _windowAdapter(this));
            this.m_animationDP = animationDP;
        }

        protected class GetNextEventAction
        extends AbstractAction {
            Dialog d;

            public GetNextEventAction(Dialog d) {
                this.d = d;
            }

            public void actionPerformed(ActionEvent e) {
                if (e.getSource() != AnimationDialog.this.buttonGetNext) {
                    return;
                }
                try {
                    IVWSIMEvent event = AnimationDialog.this.m_animationDP.getEvent();
                    System.out.println("Get next..." + event.getTimeStamp());
                    AnimationDialog.this.txtArea.setText(event.toString());
                    AnimationDialog.this.buttonStop.setEnabled(true);
                    if (event.finished()) {
                        AnimationDialog.this.buttonGetNext.setEnabled(false);
                    }
                }
                catch (Exception ex) {
                    JOptionPane.showMessageDialog(this.d, ex.getMessage(), "GET NEXT", 0);
                }
            }
        }

        protected class CloseAnimationDialogAction
        extends AbstractAction {
            Dialog d;

            public CloseAnimationDialogAction(Dialog d) {
                this.d = d;
            }

            public void actionPerformed(ActionEvent e) {
                if (e.getSource() != AnimationDialog.this.buttonStop) {
                    return;
                }
                System.out.println("Close animation DP");
                this.d.setVisible(false);
                AnimationDialog.this.m_animationDP.releaseResources();
            }
        }

        protected class RestartAnimationAction
        extends AbstractAction {
            Dialog d;

            public RestartAnimationAction(Dialog d) {
                this.d = d;
            }

            public void actionPerformed(ActionEvent e) {
                try {
                    AnimationDialog.this.m_animationDP.restart();
                    AnimationDialog.this.buttonGetNext.setEnabled(true);
                }
                catch (Exception ex) {
                    System.out.println("Restart exception=" + ex.getMessage());
                }
            }
        }

        protected class SaveEventBufferAction
        extends AbstractAction {
            Dialog d;

            public SaveEventBufferAction(Dialog d) {
                this.d = d;
            }

            public void actionPerformed(ActionEvent e) {
                if (e.getSource() != AnimationDialog.this.buttonSave) {
                    return;
                }
                System.out.println("Save Event Buffer...");
                TestAll.this.m_saveFileDialog.setTitle("Pick a filename for saving scenario definition..");
                if (TestAll.this.m_scenarioFileName != null) {
                    File aFile = new File(TestAll.this.m_scenarioFileName);
                    TestAll.this.m_saveFileDialog.setDirectory(aFile.getParent());
                    TestAll.this.m_saveFileDialog.setFile(TestAll.this.m_scenarioFileName);
                }
                TestAll.this.m_saveFileDialog.setVisible(true);
                String name = TestAll.this.m_saveFileDialog.getFile();
                if (name == null) {
                    return;
                }
                TestAll.this.m_scenarioFileName = TestAll.this.m_saveFileDialog.getDirectory() + name;
                TestAll.this.scenarioFileNameTextField.setText(TestAll.this.m_scenarioFileName);
                System.out.println("Scenario Definition will be saved to: " + TestAll.this.m_scenarioFileName);
                TestAll.this.m_saveFileDialog.setTitle("Pick a filename for saving associated event buffer..");
                TestAll.this.m_eventBufferFileName = TestAll.this.eventBufferFileNameTextField.getText();
                if (TestAll.this.m_eventBufferFileName != null) {
                    File aFile = new File(TestAll.this.m_eventBufferFileName);
                    TestAll.this.m_saveFileDialog.setDirectory(aFile.getParent());
                    TestAll.this.m_saveFileDialog.setFile(aFile.getName());
                }
                TestAll.this.m_saveFileDialog.setVisible(true);
                name = TestAll.this.m_saveFileDialog.getFile();
                if (name == null) {
                    return;
                }
                TestAll.this.m_eventBufferFileName = TestAll.this.m_saveFileDialog.getDirectory() + name;
                TestAll.this.eventBufferFileNameTextField.setText(TestAll.this.m_eventBufferFileName);
                System.out.println("Event Buffer will be saved to: " + TestAll.this.m_eventBufferFileName);
                try {
                    AnimationDialog.this.m_animationDP.writeToFiles(TestAll.this.m_scenarioFileName, TestAll.this.m_eventBufferFileName);
                }
                catch (Exception ex) {
                    JOptionPane.showMessageDialog(this.d, ex.getMessage(), "Save Event Buffer", 0);
                }
            }
        }
    }

    protected class LoadAnimationDPLocallyAction
    extends AbstractAction {
        Frame m_pFrame;

        public LoadAnimationDPLocallyAction(Frame frame) {
            this.m_pFrame = frame;
        }

        public void actionPerformed(ActionEvent e) {
            if (e.getSource() != TestAll.this.buttonLoadAnimationDPLocally) {
                return;
            }
            String s_fileName = TestAll.this.scenarioFileNameTextField.getText();
            String s_eventBufferFileName = TestAll.this.eventBufferFileNameTextField.getText();
            if (s_fileName == null || s_eventBufferFileName == null || s_fileName.length() == 0 || s_eventBufferFileName.length() == 0) {
                JOptionPane.showMessageDialog(this.m_pFrame, "Please select the event buffer and scenario!", "Animation", 2);
                return;
            }
            System.out.println("Showing Animation for Scenario=" + s_fileName + ", with event buffer=" + s_eventBufferFileName);
            try {
                IVWSIMAnimationDP animationDP = VWSIMAnimationDP.loadFromFiles(s_fileName, s_eventBufferFileName);
                AnimationDialog d = new AnimationDialog(this.m_pFrame, animationDP);
                d.setVisible(true);
            }
            catch (Throwable ex) {
                JOptionPane.showMessageDialog(this.m_pFrame, ex.getMessage(), "Animation EXCEPTION", 0);
            }
        }
    }

    protected class LoadAnimationDPViaSimDocAction
    extends AbstractAction {
        Frame m_pFrame;

        public LoadAnimationDPViaSimDocAction(Frame frame) {
            this.m_pFrame = frame;
        }

        public void actionPerformed(ActionEvent e) {
            if (e.getSource() != TestAll.this.buttonLoadAnimationDPViaSimDoc) {
                return;
            }
            try {
                openDocDialog.showDialog(null);
                IVWIDMDocument item = (IVWIDMDocument)openDocDialog.getSelectedItem();
                if (item == null) {
                    return;
                }
                System.out.println("Showing Animation for doc=" + item.getCanonicalName());
                VWSIMAnimationDP animationDP = new VWSIMAnimationDP(null, item);
                AnimationDialog d = new AnimationDialog(this.m_pFrame, animationDP);
                d.setVisible(true);
            }
            catch (Throwable ex) {
                JOptionPane.showMessageDialog(this.m_pFrame, ex.getMessage(), "Animation EXCEPTION", 0);
            }
        }
    }

    protected class ShowAnimationAction
    extends AbstractAction {
        Frame m_pFrame;

        public ShowAnimationAction(Frame frame) {
            this.m_pFrame = frame;
        }

        public void actionPerformed(ActionEvent e) {
            if (e.getSource() != TestAll.this.buttonStartAnimation) {
                return;
            }
            String s_id = TestAll.this.scenarioGUIDTextField.getText();
            String s_fileName = TestAll.this.scenarioFileNameTextField.getText();
            System.out.println("Showing Animation for ScenarioId=" + s_id + ", with Scenario Def=" + s_fileName);
            try {
                VWSIMAnimationDP animationDP = new VWSIMAnimationDP(TestAll.this.m_simEngine, s_id, s_fileName);
                AnimationDialog d = new AnimationDialog(this.m_pFrame, animationDP);
                d.setVisible(true);
            }
            catch (Throwable ex) {
                JOptionPane.showMessageDialog(this.m_pFrame, ex.getMessage(), "Animation EXCEPTION", 0);
            }
        }
    }

    protected class PickEventBufferAction
    extends AbstractAction {
        Frame m_pFrame;

        public PickEventBufferAction(Frame frame) {
            this.m_pFrame = frame;
        }

        public void actionPerformed(ActionEvent e) {
            if (e.getSource() != TestAll.this.buttonPickEventBuffer) {
                return;
            }
            System.out.println("choosing a event buffer file to work..");
            try {
                if (TestAll.this.m_eventBufferFileName != null) {
                    File aFile = new File(TestAll.this.m_eventBufferFileName);
                    TestAll.this.m_openFileDialog.setDirectory(aFile.getParent());
                    TestAll.this.m_openFileDialog.setFile(aFile.getName());
                }
                TestAll.this.m_openFileDialog.setVisible(true);
                System.out.println("File dialog comes back?");
                String name = TestAll.this.m_openFileDialog.getFile();
                if (name == null) {
                    return;
                }
                name = TestAll.this.m_openFileDialog.getDirectory() + name;
                if (TestAll.this.m_eventBufferFileName != null && name.equalsIgnoreCase(TestAll.this.m_eventBufferFileName)) {
                    return;
                }
                File localFile = new File(name);
                if (!localFile.exists()) {
                    System.out.println("File Not Found: " + name);
                    return;
                }
                TestAll.this.m_eventBufferFileName = name;
                System.out.println("You pick: " + TestAll.this.m_eventBufferFileName);
                TestAll.this.eventBufferFileNameTextField.setText(TestAll.this.m_eventBufferFileName);
            }
            catch (Throwable ex) {
                JOptionPane.showMessageDialog(this.m_pFrame, ex.getMessage(), "Pick EventBuffer Dialog EXCEPTION", 0);
            }
        }
    }

    protected class PickScenarioAction
    extends AbstractAction {
        Frame m_pFrame;

        public PickScenarioAction(Frame frame) {
            this.m_pFrame = frame;
        }

        public void actionPerformed(ActionEvent e) {
            if (e.getSource() != TestAll.this.buttonPickScenario) {
                return;
            }
            System.out.println("choosing a scenario file to work..");
            try {
                if (TestAll.this.m_scenarioFileName != null) {
                    File aFile = new File(TestAll.this.m_scenarioFileName);
                    TestAll.this.m_openFileDialog.setDirectory(aFile.getParent());
                    TestAll.this.m_openFileDialog.setFile(aFile.getName());
                }
                TestAll.this.m_openFileDialog.setVisible(true);
                System.out.println("File dialog comes back?");
                String name = TestAll.this.m_openFileDialog.getFile();
                System.out.println("picking file..." + name);
                if (name == null) {
                    TestAll.this.buttonStartSimulation.setEnabled(false);
                    return;
                }
                name = TestAll.this.m_openFileDialog.getDirectory() + name;
                File localFile = new File(name);
                if (!localFile.exists()) {
                    System.out.println("File Not Found: " + name);
                    return;
                }
                TestAll.this.m_scenarioFileName = name;
                System.out.println("You pick: " + TestAll.this.m_scenarioFileName);
                TestAll.this.m_scenarioGUID = null;
                TestAll.this.buttonStartSimulation.setEnabled(true);
                TestAll.this.scenarioFileNameTextField.setText(TestAll.this.m_scenarioFileName);
                TestAll.this.scenarioNameTextField.setText(localFile.getName());
            }
            catch (Throwable ex) {
                JOptionPane.showMessageDialog(this.m_pFrame, ex.getMessage(), "Pick Scenario Dialog EXCEPTION", 0);
            }
        }
    }

    protected class StartSimulationAction
    extends AbstractAction {
        Frame m_pFrame = null;

        public StartSimulationAction(Frame frame) {
            this.m_pFrame = frame;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() != TestAll.this.buttonStartSimulation) {
                return;
            }
            System.out.println("Start simulation..");
            BufferedReader in = null;
            try {
                in = new BufferedReader(new FileReader(TestAll.this.m_scenarioFileName));
                StringBuffer buf = new StringBuffer();
                String s = null;
                while ((s = in.readLine()) != null) {
                    buf.append(s);
                }
                String m_scenarioName = TestAll.this.scenarioNameTextField.getText();
                BasicScenario m_scenario = TestAll.this.m_simEngine.newScenario("QUYNH", 1, m_scenarioName, "Qdang", buf.toString(), null);
                TestAll.this.m_scenarioGUID = m_scenario.id;
                TestAll.this.scenarioGUIDTextField.setText(TestAll.this.m_scenarioGUID);
                TestAll.this.buttonStartAnimation.setEnabled(true);
                TestAll.this.buttonStartSimulation.setEnabled(false);
            }
            catch (Throwable ex) {
                JOptionPane.showMessageDialog(this.m_pFrame, ex.getMessage(), "Start Simulation EXCEPTION", 0);
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (Exception ex) {}
                }
            }
        }
    }

    protected class ConnectToSimEngineAction
    extends AbstractAction {
        Frame m_pFrame = null;

        public ConnectToSimEngineAction(Frame frame) {
            this.m_pFrame = frame;
        }

        public void actionPerformed(ActionEvent e) {
            if (e.getSource() != TestAll.this.buttonConnect) {
                return;
            }
            String serverName = TestAll.this.serverTextField.getText();
            String port = TestAll.this.portTextField.getText();
            TestAll.this.m_url = "rmi://" + serverName + ":" + port + "/WorkflowSimulator";
            System.out.println("connectionString=" + TestAll.this.m_url);
            try {
                TestAll.this.m_simEngine = (ISimulator)Naming.lookup(TestAll.this.m_url);
                TestAll.this.buttonConnect.setEnabled(false);
                TestAll.this.buttonGetSimulations.setEnabled(true);
            }
            catch (Throwable ex) {
                JOptionPane.showMessageDialog(this.m_pFrame, ex.getMessage(), "Connect to Sim Engine EXCEPTION", 0);
            }
        }
    }

    protected class GenerateXMLAction
    extends AbstractAction {
        Frame m_pFrame = null;

        public GenerateXMLAction(Frame frame) {
            this.m_pFrame = frame;
        }

        public void actionPerformed(ActionEvent e) {
            if (e.getSource() != TestAll.this.buttonGenerateXML) {
                return;
            }
            String routerURL = TestAll.this.PERouterTextField.getText();
            String peUser = TestAll.this.PEUserTextField.getText();
            String pePw = TestAll.this.PEPWTextField.getText();
            if (routerURL == null || routerURL.length() == 0 || peUser == null || peUser.length() == 0 || pePw == null || pePw.length() == 0) {
                JOptionPane.showMessageDialog(this.m_pFrame, "Need to specify PE parameters", "GENERATE XML", 0);
                return;
            }
            TestAll.this.m_openFileDialog.setVisible(true);
            System.out.println("File dialog comes back?");
            String name = TestAll.this.m_openFileDialog.getFile();
            System.out.println("picking file..." + name);
            if (name == null) {
                return;
            }
            name = TestAll.this.m_openFileDialog.getDirectory() + name;
            String outName = name + ".RESD";
            try {
                VWSession session = new VWSession(peUser, pePw, routerURL);
                this.generateRuntimeXML(session, name, outName);
            }
            catch (Throwable ex) {
                JOptionPane.showMessageDialog(this.m_pFrame, ex.getMessage(), "GENERATE XML", 0);
            }
        }

        private void generateRuntimeXML(VWSession session, String scenarioFile, String runtimeFile) throws Exception {
            System.out.println("Loading scenario definition.");
            VWScenarioDefinition scenarioDef = VWScenarioDefinition.readFromFile(scenarioFile);
            VWScenarioValidationError[] errors = scenarioDef.validate(session, true, true);
            if (errors != null) {
                boolean validationError = false;
                for (int i = 0; i < errors.length; ++i) {
                    if (errors[i].getErrorType() == 1) {
                        validationError = true;
                    }
                    System.out.println(errors[i].toString());
                }
                if (validationError) {
                    System.exit(1);
                }
            }
            System.out.println("Generating runtime xml.");
            StringBuffer xmlBuffer = new StringBuffer();
            scenarioDef.toRuntimeXML(session, xmlBuffer);
            FileOutputStream ostream = null;
            try {
                ostream = new FileOutputStream(runtimeFile);
                OutputStreamWriter out = new OutputStreamWriter((OutputStream)ostream, "UTF8");
                out.write(xmlBuffer.toString());
                ((Writer)out).flush();
            }
            catch (Exception e) {
                throw e;
            }
            finally {
                if (ostream != null) {
                    try {
                        ((OutputStream)ostream).close();
                    }
                    catch (Exception E) {}
                }
            }
        }
    }

    class ShowSimsDialog
    extends JDialog {
        private JButton b;
        private JList uiList;

        public ShowSimsDialog(BasicScenario[] list) throws Exception {
            super(new Frame(), true);
            this.b = null;
            this.uiList = null;
            this.getContentPane().setLayout(new BorderLayout());
            this.setTitle("Simulations from server");
            this.uiList = new JList<BasicScenario>(list);
            this.uiList.setSelectedIndex(0);
            JScrollPane scrollpane = new JScrollPane(this.uiList);
            scrollpane.setBorder(BorderFactory.createLoweredBevelBorder());
            this.getContentPane().add((Component)scrollpane, "Center");
            JPanel p = new JPanel();
            this.b = new JButton("Select");
            p.add(this.b);
            this.b.addActionListener(new SelectSimAction());
            this.b = new JButton("Delete");
            p.add(this.b);
            this.b.addActionListener(new DeleteSimAction());
            this.b = new JButton("Details...");
            p.add(this.b);
            this.b.addActionListener(new DetailsSimAction());
            this.getContentPane().add((Component)p, "South");
            this.pack();
            this.addWindowListener(new _windowAdapter(this));
        }

        protected class DeleteSimAction
        extends AbstractAction {
            protected DeleteSimAction() {
            }

            public void actionPerformed(ActionEvent ae) {
                try {
                    BasicScenario scenario = (BasicScenario)ShowSimsDialog.this.uiList.getSelectedValue();
                    TestAll.this.m_simEngine.removeScenario(scenario.id);
                    TestAll.this.m_scenarioGUID = "";
                    TestAll.this.scenarioFileNameTextField.setText("");
                    TestAll.this.scenarioGUIDTextField.setText(TestAll.this.m_scenarioGUID);
                    TestAll.this.buttonStartAnimation.setEnabled(false);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }

        protected class SelectSimAction
        extends AbstractAction {
            protected SelectSimAction() {
            }

            public void actionPerformed(ActionEvent ae) {
                try {
                    BasicScenario scenario = (BasicScenario)ShowSimsDialog.this.uiList.getSelectedValue();
                    File x = File.createTempFile("SIM", "x");
                    x.deleteOnExit();
                    BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(x));
                    out.write(scenario.scenarioXML.getBytes());
                    out.close();
                    TestAll.this.scenarioFileNameTextField.setText(x.getCanonicalPath());
                    TestAll.this.m_scenarioGUID = scenario.id;
                    TestAll.this.scenarioGUIDTextField.setText(TestAll.this.m_scenarioGUID);
                    TestAll.this.buttonStartAnimation.setEnabled(true);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }

        protected class DetailsSimAction
        extends AbstractAction {
            protected DetailsSimAction() {
            }

            public void actionPerformed(ActionEvent ae) {
                try {
                    BasicScenario scenario = (BasicScenario)ShowSimsDialog.this.uiList.getSelectedValue();
                    DetailsSimDialog dlg = new DetailsSimDialog(scenario);
                    dlg.show();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }

        class DetailsSimDialog
        extends JDialog {
            public DetailsSimDialog(BasicScenario s) throws Exception {
                super(new Frame(), true);
                this.getContentPane().setLayout(new BorderLayout());
                this.setTitle("Scenario Detail");
                String simInfo = TestAll.this.m_simEngine.getSimStatisticsInfo(s.id);
                StringBuffer buf = new StringBuffer(1024).append("Name=").append(s.name).append("\nid=").append(s.id).append("\nstatsInfo=").append(simInfo).append("\nXML=\n").append(s.scenarioXML);
                JTextArea txtArea = new JTextArea(buf.toString());
                JScrollPane scrollpane = new JScrollPane(txtArea);
                scrollpane.setBorder(BorderFactory.createLoweredBevelBorder());
                this.getContentPane().add((Component)scrollpane, "Center");
                this.pack();
                this.addWindowListener(new _windowAdapter(this));
            }
        }
    }

    protected class GetSimulationsAction
    extends AbstractAction {
        Frame m_pFrame = null;

        public GetSimulationsAction(Frame frame) {
            this.m_pFrame = frame;
        }

        public void actionPerformed(ActionEvent e) {
            if (e.getSource() != TestAll.this.buttonGetSimulations) {
                return;
            }
            try {
                BasicScenario[] scenarios = TestAll.this.m_simEngine.listScenarios();
                ShowSimsDialog dlg = new ShowSimsDialog(scenarios);
                dlg.show();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }
}

